WITH
T_COLS AS
(SELECT i.object_id, i.index_id, i.key_ordinal,
        c.name + CASE WHEN is_descending_key = 1
                         THEN ' DESC'
                      ELSE ''
                 END AS name, is_descending_key,
        MAX(key_ordinal)
        OVER(PARTITION BY i.object_id, i.index_id, is_included_column) AS n_keys,
		is_included_column
 FROM   sys.index_columns AS i
        INNER JOIN sys.columns AS c
              ON i.object_id = c.object_id
                 AND i.column_id = c.column_id),
T_KEYS AS
(SELECT object_id, index_id, key_ordinal, n_keys, is_included_column,
        CASE WHEN is_included_column = 0
                THEN CAST(name AS NVARCHAR(max))
             ELSE ''
        END AS INDEX_KEY,
        CASE WHEN is_included_column = 1
                THEN CAST(name AS NVARCHAR(max))
             ELSE ''
        END AS INDEX_INC
 FROM   T_COLS
 WHERE  key_ordinal = 1
 UNION ALL
 SELECT c.object_id, c.index_id, c.key_ordinal, c.n_keys, k.is_included_column,
        k.INDEX_KEY +
        CASE WHEN k.is_included_column = 0
                THEN ', ' + CAST(c.name AS NVARCHAR(max))
             ELSE ''
        END,
        k.INDEX_INC +
        CASE WHEN k.is_included_column = 1
                THEN ', ' + CAST(c.name AS NVARCHAR(max))
             ELSE ''
        END
 FROM   T_KEYS AS k
        INNER JOIN T_COLS AS c
              ON k.object_id = c.object_id
                 AND k.index_id = c.index_id
                 AND k.key_ordinal + 1 = c.key_ordinal)
SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME, i.name AS INDEX_NAME,
       INDEX_KEY, NULLIF(INDEX_INC,'') AS INDEX_INCLUDE
	   , filter_definition AS INDEX_WHERE  --> sauf version 2005
FROM   sys.indexes AS i
       INNER JOIN sys.objects AS o ON i.object_id = o.object_id
       INNER JOIN sys.schemas AS s ON o.schema_id = s.schema_id
       INNER JOIN T_KEYS AS k ON i.object_id = k.object_id AND i.index_id = k.index_id
WHERE  key_ordinal = n_keys
  AND  o."type" IN ('U', 'V');

--> NOTA : les index filtrs (clause WHERE) n'existant pas dans la version 2005, veuillez retirer de la requte la ligne indiqu portant sur le colonne "filter_definition".